<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Group extends Model 
{

    protected $table = 'groups';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('id', 'id_user', 'name', 'category', 'description', 'banner', 'timestamps');
    protected $visible = array('id', 'id_user', 'name', 'category', 'description', 'banner', 'timestamps');

    public function users()
    {
        return $this->hasMany('App\Models\UserGroup', 'id_group');
    }

    public function creator()
    {
        return $this->belongsTo('App\Models\User', 'id_user');
    }

}